"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "createWebsocket", {
    enumerable: true,
    get: function() {
        return createWebsocket;
    }
});
const _websocketService = require("./services/websocketService");
const _wsEvents = require("./wsEvents");
async function createWebsocket(server, ctx) {
    const { store } = ctx;
    const websocketService = await (0, _websocketService.defineWebsocketService)({
        httpServer: server,
        sequelize: store.sequelize
    });
    ctx.telegramBotService?.registerWebsocketService(websocketService);
    (0, _wsEvents.registerWebsocketEvents)({
        websocketService,
        telegramBotService: ctx.telegramBotService,
        models: store.models
    });
    return {
        websocketService
    };
}

//# sourceMappingURL=createWebsocket.js.map