"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = require("sequelize");
const ISO9075_DATE_TIME_FMT = 'YYYY-MM-DD HH24:MI:SS';
async function up(query) {
    await query.addColumn('imaging_results', 'completed_at', {
        type: _sequelize.DataTypes.DATETIMESTRING,
        allowNull: true
    });
    await query.sequelize.query(`
    UPDATE imaging_results
    SET completed_at = TO_CHAR(created_at, '${ISO9075_DATE_TIME_FMT}')
  `);
    await query.changeColumn('imaging_results', 'completed_at', {
        type: _sequelize.DataTypes.DATETIMESTRING,
        allowNull: false,
        defaultValue: _sequelize.Sequelize.fn('to_char', _sequelize.Sequelize.fn('current_timestamp', 3), ISO9075_DATE_TIME_FMT)
    });
}
async function down(query) {
    await query.removeColumn('imaging_results', 'completed_at');
}

//# sourceMappingURL=1673584098057-imagingResultsUseSeparateDateField.js.map