"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = /*#__PURE__*/ _interop_require_wildcard(require("sequelize"));
function _getRequireWildcardCache(nodeInterop) {
    if (typeof WeakMap !== "function") return null;
    var cacheBabelInterop = new WeakMap();
    var cacheNodeInterop = new WeakMap();
    return (_getRequireWildcardCache = function(nodeInterop) {
        return nodeInterop ? cacheNodeInterop : cacheBabelInterop;
    })(nodeInterop);
}
function _interop_require_wildcard(obj, nodeInterop) {
    if (!nodeInterop && obj && obj.__esModule) {
        return obj;
    }
    if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return {
            default: obj
        };
    }
    var cache = _getRequireWildcardCache(nodeInterop);
    if (cache && cache.has(obj)) {
        return cache.get(obj);
    }
    var newObj = {
        __proto__: null
    };
    var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;
    for(var key in obj){
        if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;
            if (desc && (desc.get || desc.set)) {
                Object.defineProperty(newObj, key, desc);
            } else {
                newObj[key] = obj[key];
            }
        }
    }
    newObj.default = obj;
    if (cache) {
        cache.set(obj, newObj);
    }
    return newObj;
}
const TABLE = {
    schema: 'fhir',
    tableName: 'jobs'
};
async function up(query) {
    await query.createTable(TABLE, {
        id: {
            type: _sequelize.DataTypes.UUID,
            allowNull: false,
            primaryKey: true,
            defaultValue: _sequelize.default.fn('uuid_generate_v4')
        },
        created_at: {
            type: _sequelize.default.DATE,
            defaultValue: _sequelize.default.fn('now'),
            allowNull: false
        },
        updated_at: {
            type: _sequelize.default.DATE,
            defaultValue: _sequelize.default.fn('now'),
            allowNull: false
        },
        deleted_at: _sequelize.default.DATE,
        // queue
        priority: {
            type: _sequelize.DataTypes.INTEGER,
            allowNull: false,
            defaultValue: 1000
        },
        status: {
            type: _sequelize.DataTypes.TEXT,
            defaultValue: 'Queued',
            allowNull: false
        },
        worker_id: _sequelize.DataTypes.UUID,
        started_at: _sequelize.DataTypes.DATE,
        completed_at: _sequelize.DataTypes.DATE,
        errored_at: _sequelize.DataTypes.DATE,
        error: _sequelize.DataTypes.TEXT,
        // routing
        topic: {
            type: _sequelize.DataTypes.TEXT,
            allowNull: false
        },
        discriminant: {
            type: _sequelize.DataTypes.TEXT,
            allowNull: false,
            defaultValue: _sequelize.default.fn('uuid_generate_v4'),
            unique: true
        },
        // data
        payload: {
            type: _sequelize.DataTypes.JSONB,
            allowNull: false,
            defaultValue: {}
        }
    });
    await query.sequelize.query(`
    CREATE OR REPLACE FUNCTION fhir.jobs_notify()
      RETURNS TRIGGER
      LANGUAGE PLPGSQL
    AS $$
    BEGIN
      -- avoid ever hitting the queue limit (and failing)
      IF pg_notification_queue_usage() < 0.5 THEN
        NOTIFY jobs;
      END IF;
      RETURN NEW;
    END;
    $$
  `);
    await query.sequelize.query(`
    CREATE TRIGGER fhir_jobs_insert_trigger
    AFTER INSERT ON fhir.jobs FOR EACH STATEMENT
    EXECUTE FUNCTION fhir.jobs_notify()
  `);
}
async function down(query) {
    await query.sequelize.query('DROP TRIGGER fhir_jobs_insert_trigger ON fhir.jobs');
    await query.sequelize.query('DROP FUNCTION fhir.jobs_notify()');
    await query.dropTable(TABLE);
}

//# sourceMappingURL=1673867248635-addJobTable.js.map