"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "ProgramRegistryCondition", {
    enumerable: true,
    get: function() {
        return ProgramRegistryCondition;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _Model = require("./Model");
let ProgramRegistryCondition = class ProgramRegistryCondition extends _Model.Model {
    static initModel({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            code: {
                type: _sequelize.DataTypes.TEXT,
                allowNull: false,
                unique: true
            },
            name: {
                type: _sequelize.DataTypes.TEXT,
                allowNull: false
            },
            visibilityStatus: {
                type: _sequelize.DataTypes.TEXT,
                defaultValue: _constants.VISIBILITY_STATUSES.CURRENT
            }
        }, {
            ...options,
            syncDirection: _constants.SYNC_DIRECTIONS.PULL_FROM_CENTRAL
        });
    }
    static initRelations(models) {
        this.belongsTo(models.ProgramRegistry, {
            foreignKey: {
                name: 'programRegistryId',
                allowNull: false
            },
            as: 'programRegistry'
        });
        this.hasMany(models.PatientProgramRegistrationCondition, {
            foreignKey: 'programRegistryConditionId',
            as: 'patientProgramRegistrationConditions'
        });
    }
    static buildSyncFilter() {
        return null; // syncs everywhere
    }
    static buildSyncLookupQueryDetails() {
        return null; // syncs everywhere
    }
};

//# sourceMappingURL=ProgramRegistryCondition.js.map