"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "patientSummaryHandler", {
    enumerable: true,
    get: function() {
        return patientSummaryHandler;
    }
});
const _datefns = require("date-fns");
const _expressasynchandler = /*#__PURE__*/ _interop_require_default(require("express-async-handler"));
const _bundleGenerator = require("./bundleGenerator");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
function patientSummaryHandler() {
    return (0, _expressasynchandler.default)(async (req, res)=>{
        const { id: patientId } = req.params;
        const { models } = req.store;
        const { patient, bundle } = await (0, _bundleGenerator.generateIPSBundle)(patientId, req.user, models);
        res.header('Last-Modified', (0, _datefns.formatRFC7231)(patient.updatedAt));
        res.send(bundle);
    });
}

//# sourceMappingURL=index.js.map