"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "PatientOngoingPrescription", {
    enumerable: true,
    get: function() {
        return PatientOngoingPrescription;
    }
});
const _constants = require("@tamanu/constants");
const _Model = require("./Model");
const _buildPatientSyncFilterViaPatientId = require("../sync/buildPatientSyncFilterViaPatientId");
const _buildPatientLinkedLookupFilter = require("../sync/buildPatientLinkedLookupFilter");
function _define_property(obj, key, value) {
    if (key in obj) {
        Object.defineProperty(obj, key, {
            value: value,
            enumerable: true,
            configurable: true,
            writable: true
        });
    } else {
        obj[key] = value;
    }
    return obj;
}
let PatientOngoingPrescription = class PatientOngoingPrescription extends _Model.Model {
    static initModel({ primaryKey, ...options }) {
        super.init({
            id: primaryKey
        }, {
            ...options,
            syncDirection: _constants.SYNC_DIRECTIONS.BIDIRECTIONAL
        });
    }
    static initRelations(models) {
        this.belongsTo(models.Patient, {
            foreignKey: 'patientId',
            as: 'patient'
        });
        this.belongsTo(models.Prescription, {
            foreignKey: 'prescriptionId',
            as: 'prescription'
        });
    }
    static async buildSyncLookupQueryDetails() {
        return (0, _buildPatientLinkedLookupFilter.buildPatientLinkedLookupFilter)(this);
    }
};
_define_property(PatientOngoingPrescription, "buildPatientSyncFilter", _buildPatientSyncFilterViaPatientId.buildPatientSyncFilterViaPatientId);

//# sourceMappingURL=PatientOngoingPrescription.js.map