"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "LabRequestLog", {
    enumerable: true,
    get: function() {
        return LabRequestLog;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _buildEncounterLinkedSyncFilter = require("../sync/buildEncounterLinkedSyncFilter");
const _Model = require("./Model");
const _buildSyncLookupSelect = require("../sync/buildSyncLookupSelect");
const LAB_REQUEST_STATUS_VALUES = Object.values(_constants.LAB_REQUEST_STATUSES);
let LabRequestLog = class LabRequestLog extends _Model.Model {
    static initModel({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            status: _sequelize.DataTypes.ENUM(...LAB_REQUEST_STATUS_VALUES)
        }, {
            ...options,
            syncDirection: _constants.SYNC_DIRECTIONS.BIDIRECTIONAL
        });
    }
    static initRelations(models) {
        this.belongsTo(models.LabRequest, {
            foreignKey: 'labRequestId',
            as: 'labRequest'
        });
        this.belongsTo(models.User, {
            foreignKey: 'updatedById',
            as: 'updatedBy'
        });
    }
    static getListReferenceAssociations() {
        return [
            'labRequest',
            'updatedBy'
        ];
    }
    static buildPatientSyncFilter(patientCount, markedForSyncPatientsTable) {
        if (patientCount === 0) {
            return null;
        }
        return (0, _buildEncounterLinkedSyncFilter.buildEncounterLinkedSyncFilter)([
            this.tableName,
            'lab_requests',
            'encounters'
        ], markedForSyncPatientsTable);
    }
    static async buildSyncLookupQueryDetails() {
        return {
            select: await (0, _buildSyncLookupSelect.buildSyncLookupSelect)(this, {
                patientId: 'encounters.patient_id',
                isLabRequestValue: 'TRUE'
            }),
            joins: (0, _buildEncounterLinkedSyncFilter.buildEncounterLinkedSyncFilterJoins)([
                this.tableName,
                'lab_requests',
                'encounters'
            ])
        };
    }
};

//# sourceMappingURL=LabRequestLog.js.map