"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "Template", {
    enumerable: true,
    get: function() {
        return Template;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _Model = require("./Model");
const _dateTime = require("@tamanu/utils/dateTime");
const _model = require("../types/model");
const TEMPLATE_TYPES_VALUES = Object.values(_constants.TEMPLATE_TYPES);
let Template = class Template extends _Model.Model {
    static initModel({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            name: {
                type: _sequelize.DataTypes.TEXT,
                allowNull: false
            },
            dateCreated: (0, _model.dateType)('dateCreated', {
                defaultValue: _dateTime.getCurrentDateString
            }),
            title: {
                type: _sequelize.DataTypes.TEXT
            },
            body: {
                type: _sequelize.DataTypes.TEXT
            },
            type: {
                type: _sequelize.DataTypes.ENUM(...TEMPLATE_TYPES_VALUES),
                allowNull: false
            },
            visibilityStatus: {
                type: _sequelize.DataTypes.TEXT,
                defaultValue: _constants.VISIBILITY_STATUSES.CURRENT
            }
        }, {
            ...options,
            syncDirection: _constants.SYNC_DIRECTIONS.PULL_FROM_CENTRAL
        });
    }
    static initRelations(models) {
        this.belongsTo(models.User, {
            foreignKey: 'createdById',
            as: 'createdBy'
        });
    }
    static getListReferenceAssociations() {
        return [
            'createdBy'
        ];
    }
    static buildSyncFilter() {
        return null; // syncs everywhere
    }
    static async buildSyncLookupQueryDetails() {
        return null; // syncs everywhere
    }
};

//# sourceMappingURL=Template.js.map