"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "FhirHumanName", {
    enumerable: true,
    get: function() {
        return FhirHumanName;
    }
});
const _chance = require("chance");
const _lodash = require("lodash");
const _yup = /*#__PURE__*/ _interop_require_wildcard(require("yup"));
const _baseType = require("./baseType");
const _period = require("./period");
function _getRequireWildcardCache(nodeInterop) {
    if (typeof WeakMap !== "function") return null;
    var cacheBabelInterop = new WeakMap();
    var cacheNodeInterop = new WeakMap();
    return (_getRequireWildcardCache = function(nodeInterop) {
        return nodeInterop ? cacheNodeInterop : cacheBabelInterop;
    })(nodeInterop);
}
function _interop_require_wildcard(obj, nodeInterop) {
    if (!nodeInterop && obj && obj.__esModule) {
        return obj;
    }
    if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return {
            default: obj
        };
    }
    var cache = _getRequireWildcardCache(nodeInterop);
    if (cache && cache.has(obj)) {
        return cache.get(obj);
    }
    var newObj = {
        __proto__: null
    };
    var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;
    for(var key in obj){
        if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;
            if (desc && (desc.get || desc.set)) {
                Object.defineProperty(newObj, key, desc);
            } else {
                newObj[key] = obj[key];
            }
        }
    }
    newObj.default = obj;
    if (cache) {
        cache.set(obj, newObj);
    }
    return newObj;
}
const USES = [
    'usual',
    'official',
    'temp',
    'nickname',
    'anonymous',
    'old',
    'maiden'
];
let FhirHumanName = class FhirHumanName extends _baseType.FhirBaseType {
    static SCHEMA() {
        return _yup.object({
            use: _yup.string().oneOf([
                null,
                ...USES
            ]).nullable().default(null),
            text: _yup.string().nullable().default(null),
            family: _yup.string().nullable().default(null),
            given: _yup.array().of(_yup.string()).nullable().default([]),
            prefix: _yup.array().of(_yup.string()).nullable().default([]),
            suffix: _yup.array().of(_yup.string()).nullable().default([]),
            period: _period.FhirPeriod.asYup().nullable().default(null)
        }).noUnknown();
    }
    static fake() {
        const chance = new _chance.Chance();
        return new this({
            use: (0, _lodash.sample)(USES),
            family: chance.last(),
            given: [
                chance.first()
            ]
        });
    }
};

//# sourceMappingURL=humanName.js.map