"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "honeycombTransport", {
    enumerable: true,
    get: function() {
        return honeycombTransport;
    }
});
const _winstontransport = /*#__PURE__*/ _interop_require_default(require("winston-transport"));
const _libhoney = /*#__PURE__*/ _interop_require_default(require("libhoney"));
const _config = /*#__PURE__*/ _interop_require_default(require("config"));
const _context = require("./context");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const context = (0, _context.serviceContext)();
const { apiKey, enabled, level = 'info' } = _config.default?.honeycomb || {};
const dataset = (0, _context.serviceName)(context);
const honeyApi = new _libhoney.default({
    writeKey: apiKey,
    dataset,
    disabled: !(apiKey && enabled && dataset)
});
let HoneycombTransport = class HoneycombTransport extends _winstontransport.default {
    log(info, callback) {
        const event = honeyApi.newEvent();
        event.add(context);
        event.add(info);
        event.send();
        callback();
    }
};
const honeycombTransport = new HoneycombTransport({
    level
});

//# sourceMappingURL=honeycomb.js.map