"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "getConditions", {
    enumerable: true,
    get: function() {
        return getConditions;
    }
});
const _uuid = require("uuid");
const _constants = require("@tamanu/constants");
const _fhir = require("@tamanu/shared/utils/fhir");
const _utils = require("../utils");
const getConditions = async ({ patient, models, dataDictionariesIps })=>{
    const patientConditions = await models.PatientCondition.findAll({
        where: {
            patientId: patient.id
        },
        include: [
            'condition'
        ]
    });
    const clinicalStatusObject = (condition = {})=>({
            coding: [
                {
                    system: 'http://terminology.hl7.org/CodeSystem/condition-clinical',
                    code: condition.resolved ? 'resolved' : 'active'
                }
            ]
        });
    const patientConditionsHeader = {
        resourceType: _constants.FHIR_RESOURCE_TYPES.CONDITION,
        subject: (0, _utils.getEntryResourceSubject)(patient),
        clinicalStatus: clinicalStatusObject()
    };
    if (!patientConditions?.length) {
        const conditionCodingDisplay = 'No information about problems';
        return [
            {
                id: (0, _uuid.v4)(),
                ...patientConditionsHeader,
                clinicalStatus: clinicalStatusObject(),
                code: {
                    coding: [
                        {
                            system: dataDictionariesIps.absentUnknown,
                            code: 'no-problem-info',
                            display: conditionCodingDisplay
                        }
                    ]
                },
                text: {
                    status: 'generated',
                    div: `<div xmlns="http://www.w3.org/1999/xhtml">These are the Condition details for ${patient.displayName} for ${conditionCodingDisplay}. Please review the data for more detail.</div>`
                }
            }
        ];
    }
    return patientConditions.map((patientCondition)=>({
            id: (0, _uuid.v4)(),
            ...patientConditionsHeader,
            clinicalStatus: clinicalStatusObject(patientCondition),
            code: {
                coding: [
                    {
                        system: dataDictionariesIps.conditionEncoding,
                        code: patientCondition.condition.code,
                        display: patientCondition.condition.name
                    }
                ]
            },
            text: {
                status: 'generated',
                div: `<div xmlns="http://www.w3.org/1999/xhtml">These are the Condition details for ${patient.displayName} for ${patientCondition.condition.name}. Please review the data for more detail.</div>`
            },
            onsetPeriod: {
                end: (0, _fhir.formatFhirDate)(patientCondition.resolutionDate)
            }
        }));
};

//# sourceMappingURL=condition.js.map