"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = require("sequelize");
const TABLE_NAME = 'appointments';
const ISO9075_DATE_TIME_FMT = 'YYYY-MM-DD HH24:MI:SS';
async function up(query) {
    await query.addColumn(TABLE_NAME, 'start_time_legacy', {
        type: _sequelize.DataTypes.DATE
    });
    await query.addColumn(TABLE_NAME, 'end_time_legacy', {
        type: _sequelize.DataTypes.DATE
    });
    await query.sequelize.query(`
    UPDATE ${TABLE_NAME}
    SET 
      start_time_legacy = start_time,
      end_time_legacy = end_time;
  `);
    await query.sequelize.query(`
  ALTER TABLE ${TABLE_NAME} 
  ALTER COLUMN start_time TYPE CHAR(19) USING TO_CHAR(start_time, '${ISO9075_DATE_TIME_FMT}'),
  ALTER COLUMN end_time TYPE CHAR(19) USING TO_CHAR(end_time, '${ISO9075_DATE_TIME_FMT}');
`);
}
async function down(query) {
    await query.sequelize.query(`
    ALTER TABLE ${TABLE_NAME}
    ALTER COLUMN start_time TYPE timestamp with time zone USING start_time_legacy,
    ALTER COLUMN end_time TYPE timestamp with time zone USING end_time_legacy;
  `);
    await query.removeColumn(TABLE_NAME, 'start_time_legacy');
    await query.removeColumn(TABLE_NAME, 'end_time_legacy');
}

//# sourceMappingURL=090_alterAppointmentDateFields.js.map