"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "FhirEncounter", {
    enumerable: true,
    get: function() {
        return FhirEncounter;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _Resource = require("./Resource");
const _fhirTypes = require("@tamanu/shared/services/fhirTypes");
const _Encounter = require("../../utils/fhir/Encounter");
function _define_property(obj, key, value) {
    if (key in obj) {
        Object.defineProperty(obj, key, {
            value: value,
            enumerable: true,
            configurable: true,
            writable: true
        });
    } else {
        obj[key] = value;
    }
    return obj;
}
let FhirEncounter = class FhirEncounter extends _Resource.FhirResource {
    static initModel(options, models) {
        super.initResource({
            status: {
                type: _sequelize.DataTypes.TEXT,
                allowNull: false
            },
            class: _sequelize.DataTypes.JSONB,
            subject: _sequelize.DataTypes.JSONB,
            actualPeriod: _sequelize.DataTypes.JSONB,
            location: _sequelize.DataTypes.JSONB,
            serviceProvider: _sequelize.DataTypes.JSONB
        }, options);
        this.UpstreamModels = [
            models.Encounter
        ];
        this.upstreams = [
            models.Encounter,
            models.Discharge,
            models.Patient,
            models.Location,
            models.LocationGroup
        ];
    }
    async updateMaterialisation() {
        const upstream = await this.getUpstream((0, _Encounter.getQueryOptions)(this.sequelize.models));
        const values = await (0, _Encounter.getValues)(upstream, this.sequelize.models);
        this.set(values);
    }
    static async queryToFindUpstreamIdsFromTable(upstreamTable, table, id, deletedRow = null) {
        const { Encounter } = this.sequelize.models;
        if (upstreamTable === Encounter.tableName) {
            return (0, _Encounter.fromEncounters)(this.sequelize.models, table, id, deletedRow);
        }
        return null;
    }
    static async queryToFilterUpstream(upstreamTable) {
        const { Encounter } = this.sequelize.models;
        if (upstreamTable === Encounter.tableName) {
            return (0, _Encounter.filterFromEncounters)(this.sequelize.models, upstreamTable);
        }
        return null;
    }
    asFhir() {
        const resource = super.asFhir();
        const { FhirPatient } = this.sequelize.models;
        // Exclude unresolved upstream if it remains in the materialised data.
        if (resource.subject.type === _fhirTypes.FhirReference.unresolvedReferenceType(FhirPatient)) {
            delete resource.subject;
        }
        return resource;
    }
    static searchParameters() {
        return {
            ...super.searchParameters(),
            ..._Encounter.searchParameters
        };
    }
};
_define_property(FhirEncounter, "CAN_DO", new Set([
    _constants.FHIR_INTERACTIONS.INSTANCE.READ,
    _constants.FHIR_INTERACTIONS.TYPE.SEARCH,
    _constants.FHIR_INTERACTIONS.INTERNAL.MATERIALISE
]));

//# sourceMappingURL=FhirEncounter.js.map