"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    getModelsForDirections: function() {
        return getModelsForDirections;
    },
    getModelsForPull: function() {
        return getModelsForPull;
    },
    getModelsForPush: function() {
        return getModelsForPush;
    }
});
const _constants = require("@tamanu/constants");
const getModelsForDirections = (models, directions)=>{
    return Object.fromEntries(Object.entries(models).filter(([, model])=>directions.includes(model.syncDirection)));
};
const getModelsForPull = (models)=>getModelsForDirections(models, [
        _constants.SYNC_DIRECTIONS.PULL_FROM_CENTRAL,
        _constants.SYNC_DIRECTIONS.BIDIRECTIONAL
    ]);
const getModelsForPush = (models)=>getModelsForDirections(models, [
        _constants.SYNC_DIRECTIONS.PUSH_TO_CENTRAL,
        _constants.SYNC_DIRECTIONS.PUSH_TO_CENTRAL_THEN_DELETE,
        _constants.SYNC_DIRECTIONS.BIDIRECTIONAL
    ]);

//# sourceMappingURL=getModelsForDirection.js.map