"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.findUp = findUp;
exports.normalizePath = normalizePath;
const fs = __importStar(require("fs"));
const path = __importStar(require("path"));
function exists(name, type, stat) {
    try {
        const stats = stat(name, { throwIfNoEntry: false });
        switch (type) {
            case "file":
                return Boolean(stats === null || stats === void 0 ? void 0 : stats.isFile());
            case "directory":
                return Boolean(stats === null || stats === void 0 ? void 0 : stats.isDirectory());
        }
    }
    catch (_) {
        // ignore
    }
    return false;
}
/**
 * Finds the specified file(s) or directory(s) by walking up parent directories.
 * @param names One or multiple names to search for
 * @param options
 */
function findUp(names, { type = "file", startDir = process.cwd(), stopAt, allowSymlinks = true, } = {}) {
    const stat = allowSymlinks ? fs.statSync : fs.lstatSync;
    let directory = path.resolve(startDir);
    const { root } = path.parse(directory);
    stopAt = path.resolve(directory, stopAt !== null && stopAt !== void 0 ? stopAt : root);
    names = Array.isArray(names) ? names : [names];
    while (directory && directory !== stopAt && directory !== root) {
        for (const name of names) {
            const p = path.isAbsolute(name) ? name : path.join(directory, name);
            if (exists(p, type, stat)) {
                return p;
            }
        }
        directory = path.dirname(directory);
    }
    return undefined;
}
/**
 * Normalize the separators in a path, converting each backslash ('\\') to a foreward
 * slash ('/').
 *
 * @param p Path to normalize
 * @returns Normalized path
 */
function normalizePath(p) {
    return p.replace(/\\/g, "/");
}
//# sourceMappingURL=path.js.map