"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "InvoiceDiscount", {
    enumerable: true,
    get: function() {
        return InvoiceDiscount;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _Model = require("./Model");
const _buildEncounterLinkedSyncFilter = require("../sync/buildEncounterLinkedSyncFilter");
const _buildSyncLookupSelect = require("../sync/buildSyncLookupSelect");
const _model = require("../types/model");
let InvoiceDiscount = class InvoiceDiscount extends _Model.Model {
    static initModel({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            percentage: {
                type: _sequelize.DataTypes.DECIMAL,
                allowNull: false
            },
            reason: _sequelize.DataTypes.STRING,
            isManual: {
                type: _sequelize.DataTypes.BOOLEAN,
                allowNull: false
            },
            appliedTime: (0, _model.dateTimeType)('appliedTime', {
                allowNull: false
            })
        }, {
            ...options,
            syncDirection: _constants.SYNC_DIRECTIONS.BIDIRECTIONAL
        });
    }
    static initRelations(models) {
        this.belongsTo(models.Invoice, {
            foreignKey: 'invoiceId',
            as: 'invoice'
        });
        this.belongsTo(models.User, {
            foreignKey: 'appliedByUserId',
            as: 'appliedByUser'
        });
    }
    static buildPatientSyncFilter(patientCount, markedForSyncPatientsTable) {
        if (patientCount === 0) {
            return null;
        }
        return (0, _buildEncounterLinkedSyncFilter.buildEncounterLinkedSyncFilter)([
            this.tableName,
            'invoices',
            'encounters'
        ], markedForSyncPatientsTable);
    }
    static async buildSyncLookupQueryDetails() {
        return {
            select: await (0, _buildSyncLookupSelect.buildSyncLookupSelect)(this, {
                patientId: 'encounters.patient_id'
            }),
            joins: (0, _buildEncounterLinkedSyncFilter.buildEncounterLinkedSyncFilterJoins)([
                this.tableName,
                'invoices',
                'encounters'
            ])
        };
    }
};

//# sourceMappingURL=InvoiceDiscount.js.map