"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    buildNoteLinkedJoins: function() {
        return buildNoteLinkedJoins;
    },
    buildNoteLinkedSyncFilter: function() {
        return buildNoteLinkedSyncFilter;
    },
    getPatientIdColumnOfNotes: function() {
        return getPatientIdColumnOfNotes;
    }
});
const _case = require("case");
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const recordTypesWithPatientViaEncounter = [
    'Triage',
    'LabRequest',
    'ImagingRequest'
];
function getRecordTypesToTables() {
    return _constants.NOTE_RECORD_TYPE_VALUES.reduce((acc, recordType)=>{
        acc[recordType] = _sequelize.Utils.pluralize((0, _case.snake)(recordType));
        return acc;
    }, {});
}
function getPatientIdColumnOfNotes() {
    const recordTypesToTables = getRecordTypesToTables();
    const nonEncounterLinkedRecordTypeTables = _constants.NOTE_RECORD_TYPE_VALUES.filter((r)=>r !== _constants.NOTE_RECORD_TYPES.PATIENT && !recordTypesWithPatientViaEncounter.includes(r)).map((r)=>recordTypesToTables[r]);
    const encounterTables = recordTypesWithPatientViaEncounter.map((r)=>`${recordTypesToTables[r]}_encounters`);
    const patientTablesFromNotes = [
        ...nonEncounterLinkedRecordTypeTables,
        ...encounterTables
    ];
    const patientIdColumns = patientTablesFromNotes.map((t)=>`${t}.patient_id`);
    return `coalesce(${patientIdColumns.join(', ')})`;
}
function buildNoteLinkedJoins() {
    const recordTypesToTables = getRecordTypesToTables();
    let joins = _constants.NOTE_RECORD_TYPE_VALUES.filter((r)=>r !== _constants.NOTE_RECORD_TYPES.PATIENT).map((r)=>`LEFT JOIN ${recordTypesToTables[r]} ON notes.record_id = ${recordTypesToTables[r]}.id AND notes.record_type = '${r}'`);
    joins = joins.concat(recordTypesWithPatientViaEncounter.map((r)=>`LEFT JOIN encounters AS ${recordTypesToTables[r]}_encounters ON ${recordTypesToTables[r]}.encounter_id = ${recordTypesToTables[r]}_encounters.id`));
    return joins;
}
function buildNoteLinkedSyncFilter(patientCount, markedForSyncPatientsTable, sessionConfig) {
    if (patientCount === 0) {
        return null;
    }
    const recordTypesToTables = {};
    _constants.NOTE_RECORD_TYPE_VALUES.forEach((r)=>{
        recordTypesToTables[r] = _sequelize.Utils.pluralize((0, _case.snake)(r));
    });
    const joins = buildNoteLinkedJoins();
    const whereOrs = [
        `
      ( notes.record_id IN (SELECT patient_id FROM ${markedForSyncPatientsTable}) AND notes.record_type = '${_constants.NOTE_RECORD_TYPES.PATIENT}')
    `,
        ..._constants.NOTE_RECORD_TYPE_VALUES.filter((r)=>recordTypesWithPatientViaEncounter.includes(r)).map((r)=>`( ${recordTypesToTables[r]}_encounters.patient_id IN (SELECT patient_id FROM ${markedForSyncPatientsTable}) AND notes.record_type = '${r}' )`),
        ..._constants.NOTE_RECORD_TYPE_VALUES.filter((r)=>!recordTypesWithPatientViaEncounter.includes(r) && r !== 'Patient').map((r)=>`( ${recordTypesToTables[r]}.patient_id IN (SELECT patient_id FROM ${markedForSyncPatientsTable}) AND notes.record_type = '${r}' )`)
    ];
    const join = `
    ${joins.join('\n')}
  `;
    if (sessionConfig.syncAllLabRequests) {
        whereOrs.push(`notes.record_type = '${_constants.NOTE_RECORD_TYPES.LAB_REQUEST}'`);
    }
    return `
    ${join}
    WHERE (
      ${whereOrs.join('\nOR ')}
    )
    AND notes.updated_at_sync_tick > :since
  `;
}

//# sourceMappingURL=buildNoteLinkedSyncFilter.js.map