import { Model } from './Model';
import { type InitOptions, type Models } from '../types/model';
export declare class Procedure extends Model {
    id: string;
    completed: boolean;
    date: string;
    endTime?: string;
    startTime?: string;
    note?: string;
    completedNote?: string;
    encounterId?: string;
    locationId?: string;
    procedureTypeId?: string;
    physicianId?: string;
    assistantId?: string;
    anaesthetistId?: string;
    anaestheticId?: string;
    static initModel({ primaryKey, ...options }: InitOptions): void;
    static getListReferenceAssociations(): string[];
    static initRelations(models: Models): void;
    static buildPatientSyncFilter(patientCount: number, markedForSyncPatientsTable: string): string | null;
    static buildSyncLookupQueryDetails(): Promise<{
        select: string;
        joins: string;
    }>;
}
//# sourceMappingURL=Procedure.d.ts.map