//! CountryDateTime functions are server only
//! Servers require a specific reference to timeZone since most of our servers are in UTC
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    dateTimeStringIntoCountryTimezone: function() {
        return dateTimeStringIntoCountryTimezone;
    },
    getCurrentCountryTimeZoneDateString: function() {
        return getCurrentCountryTimeZoneDateString;
    },
    getCurrentCountryTimeZoneDateTimeString: function() {
        return getCurrentCountryTimeZoneDateTimeString;
    },
    toCountryDateString: function() {
        return toCountryDateString;
    },
    toCountryDateTimeString: function() {
        return toCountryDateTimeString;
    }
});
const _datefns = require("date-fns");
const _datefnstz = require("date-fns-tz");
const _config = /*#__PURE__*/ _interop_require_default(require("config"));
const _dateTime = require("@tamanu/utils/dateTime");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
function toCountryDateTimeString(date) {
    if (date === null || date === undefined) {
        return null;
    }
    return (0, _datefnstz.formatInTimeZone)(date, _config.default?.countryTimeZone, _dateTime.ISO9075_DATETIME_FORMAT);
}
function toCountryDateString(date) {
    if (date === null || date === undefined) {
        return null;
    }
    return (0, _datefnstz.formatInTimeZone)(date, _config.default?.countryTimeZone, _dateTime.ISO9075_DATE_FORMAT);
}
function dateTimeStringIntoCountryTimezone(date) {
    if (date === null || date === undefined) {
        return null;
    }
    return (0, _datefns.parseISO)((0, _datefnstz.formatInTimeZone)(date, _config.default?.countryTimeZone, _dateTime.ISO8061_WITH_TIMEZONE));
}
function getCurrentCountryTimeZoneDateTimeString() {
    // Use the countryTimeZone if set, other wise fallback to the server time zone
    if (_config.default?.countryTimeZone) {
        return (0, _datefnstz.formatInTimeZone)(new Date(), _config.default.countryTimeZone, _dateTime.ISO9075_DATETIME_FORMAT);
    }
    return (0, _datefns.formatISO9075)(new Date());
}
function getCurrentCountryTimeZoneDateString() {
    // Use the countryTimeZone if set, other wise fallback to the server time zone
    if (_config.default?.countryTimeZone) {
        return (0, _datefnstz.formatInTimeZone)(new Date(), _config.default.countryTimeZone, _dateTime.ISO9075_DATE_FORMAT);
    }
    return (0, _datefns.formatISO9075)(new Date(), {
        representation: 'date'
    });
}

//# sourceMappingURL=countryDateTime.js.map