import { SYNC_DIRECTIONS } from '@tamanu/constants';
import { DataTypes } from 'sequelize';
import { Model } from './Model';
import { buildEncounterLinkedSyncFilter } from '../sync/buildEncounterLinkedSyncFilter';
import { dateTimeType } from '../types/model';
import { buildEncounterLinkedLookupJoins, buildEncounterLinkedLookupSelect } from '../sync/buildEncounterLinkedLookupFilter';
export class EncounterPausePrescriptionHistory extends Model {
    static initModel({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            action: {
                type: DataTypes.STRING,
                allowNull: false
            },
            actionDate: dateTimeType('actionDate', {
                allowNull: false
            }),
            notes: {
                type: DataTypes.TEXT,
                allowNull: true
            },
            pauseDuration: {
                type: DataTypes.DECIMAL,
                allowNull: true
            },
            pauseTimeUnit: {
                type: DataTypes.STRING,
                allowNull: true
            }
        }, {
            ...options,
            syncDirection: SYNC_DIRECTIONS.BIDIRECTIONAL,
            tableName: 'encounter_pause_prescription_histories'
        });
    }
    static initRelations(models) {
        this.belongsTo(models.EncounterPrescription, {
            foreignKey: 'encounterPrescriptionId',
            as: 'encounterPrescription'
        });
        this.belongsTo(models.User, {
            foreignKey: 'actionUserId',
            as: 'actionUser'
        });
    }
    static buildPatientSyncFilter(patientCount, markedForSyncPatientsTable) {
        if (patientCount === 0) {
            return null;
        }
        return buildEncounterLinkedSyncFilter([
            this.tableName,
            'encounter_prescriptions',
            'encounters'
        ], markedForSyncPatientsTable);
    }
    static buildSyncLookupQueryDetails() {
        return {
            select: buildEncounterLinkedLookupSelect(this),
            joins: buildEncounterLinkedLookupJoins(this, [
                'encounter_prescriptions',
                'encounters'
            ])
        };
    }
}

//# sourceMappingURL=EncounterPausePrescriptionHistory.js.map