"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "SendStatusToMetaServer", {
    enumerable: true,
    get: function() {
        return SendStatusToMetaServer;
    }
});
const _config = /*#__PURE__*/ _interop_require_default(require("config"));
const _nodepath = /*#__PURE__*/ _interop_require_default(require("node:path"));
const _nodeos = /*#__PURE__*/ _interop_require_default(require("node:os"));
const _sequelize = require("sequelize");
const _undici = require("undici");
const _logging = require("@tamanu/shared/services/logging");
const _constants = require("@tamanu/constants");
const _ScheduledTask = require("./ScheduledTask");
const _context = require("../services/logging/context");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
let SendStatusToMetaServer = class SendStatusToMetaServer extends _ScheduledTask.ScheduledTask {
    getName() {
        return 'SendStatusToMetaServer';
    }
    constructor(context, overrideConfig = null){
        const { 'service.type': serverType, 'service.version': version } = (0, _context.serviceContext)();
        const { schedule, jitterTime, enabled } = overrideConfig || _config.default.schedules.sendStatusToMetaServer;
        super(schedule, _logging.log, jitterTime, enabled);
        this.context = context;
        this.models = context.models || context.store.models;
        this.sequelize = context.sequelize || context.store.sequelize;
        this.serverType = serverType;
        this.version = version;
    }
    async fetch(path, options) {
        const deviceKey = await this.models.LocalSystemFact.getDeviceKey();
        const response = await (0, _undici.fetch)(`${_config.default.metaServer.host}/${path}`, {
            ...options,
            headers: {
                Accept: 'application/json',
                'X-Tamanu-Client': this.serverType,
                'X-Version': this.version,
                'Content-Type': 'application/json',
                'User-Agent': `Tamanu/${this.version} Node.js/${process.version.replace(/^v/, '')}`,
                ...options.headers
            },
            timeout: _config.default.metaServer.timeoutMs,
            dispatcher: new _undici.Agent({
                connect: {
                    cert: deviceKey.makeCertificate(),
                    key: deviceKey.privateKeyPem()
                }
            })
        });
        if (response.status === 403) {
            _logging.log.info(`Post of server to meta server unauthorised:\n${deviceKey.publicKeyPem()}`);
        }
        if (response.status !== 200) {
            throw new Error(`Failed to fetch from meta server: ${response.statusText}`);
        }
        return response.json();
    }
    async getMetaServerId() {
        this.metaServerId = await this.models.LocalSystemFact.get(_constants.FACT_META_SERVER_ID);
        if (this.metaServerId) return this.metaServerId;
        console.log(_nodepath.default.join('http://', _nodeos.default.hostname()));
        this.metaServerId = _config.default.metaServer.serverId || (await this.fetch('servers', {
            method: 'POST',
            body: JSON.stringify({
                host: _config.default.canonicalHostName || _nodepath.default.join('http://', _nodeos.default.hostname()),
                kind: this.serverType
            })
        }))?.id;
        await this.models.LocalSystemFact.set(_constants.FACT_META_SERVER_ID, this.metaServerId);
        return this.metaServerId;
    }
    async run() {
        const currentSyncTick = await this.models.LocalSystemFact.get(_constants.FACT_CURRENT_SYNC_TICK);
        const pgVersionResult = await this.sequelize.query(`SELECT version()`, {
            type: _sequelize.QueryTypes.SELECT
        });
        const metaServerId = await this.getMetaServerId();
        await this.fetch(`status/${metaServerId}`, {
            method: 'POST',
            body: JSON.stringify({
                currentSyncTick,
                timezone: _config.default.countryTimeZone,
                pgVersion: pgVersionResult[0].version
            })
        });
    }
};

//# sourceMappingURL=SendStatusToMetaServer.js.map