"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
async function up(query) {
    await query.sequelize.query(`
      CREATE TRIGGER fhir_refresh
      AFTER INSERT OR UPDATE OR DELETE ON notes
      FOR EACH ROW EXECUTE FUNCTION fhir.refresh_trigger();
    `);
}
async function down(query) {
    await query.sequelize.query(`DROP TRIGGER IF EXISTS fhir_refresh ON notes;`);
}

//# sourceMappingURL=1688259204459-addFhirTriggersForNotesTable.js.map