import { Model } from './Model';
import { type InitOptions, type Models } from '../types/model';
import type { Encounter } from './Encounter';
export declare class EncounterHistory extends Model {
    id: string;
    encounterType: string;
    changeType?: string;
    date: string;
    encounterId?: string;
    examinerId?: string;
    locationId?: string;
    departmentId?: string;
    actorId?: string;
    static initModel({ primaryKey, ...options }: InitOptions): void;
    static initRelations(models: Models): void;
    static createSnapshot(encounter: Encounter, { actorId, changeType, submittedTime, }: {
        actorId: string;
        changeType?: string;
        submittedTime?: string;
    }, options?: {}): Promise<EncounterHistory>;
    static buildPatientSyncFilter(patientCount: number, markedForSyncPatientsTable: string): string | null;
    static buildSyncLookupQueryDetails(): {
        select: string;
        joins: string;
    };
}
//# sourceMappingURL=EncounterHistory.d.ts.map