// File is mirrored on mobile; if you change this, change mobile too
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "calculatePageLimit", {
    enumerable: true,
    get: function() {
        return calculatePageLimit;
    }
});
const _config = /*#__PURE__*/ _interop_require_default(require("config"));
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const calculatePageLimit = (currentLimit, lastPageTime, dynamicLimiter = _config.default.sync.dynamicLimiter)=>{
    const { initialLimit, minLimit, maxLimit, optimalTimePerPageMs, maxLimitChangePerPage } = dynamicLimiter;
    if (!currentLimit) {
        return initialLimit;
    }
    // if the time is negative, the clock has gone backwards, so we can't reliably use it.
    // we ignore that event and return the current limit.
    if (lastPageTime < 0) {
        return currentLimit;
    }
    const durationPerRecord = lastPageTime / currentLimit;
    const optimalLimit = optimalTimePerPageMs / durationPerRecord;
    return Math.min(Math.max(Math.floor(optimalLimit), minLimit, Math.floor(currentLimit - currentLimit * maxLimitChangePerPage)), maxLimit, Math.ceil(currentLimit + currentLimit * maxLimitChangePerPage));
};

//# sourceMappingURL=calculatePageLimit.js.map