"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    imagingCancellationReasonsDefault: function() {
        return imagingCancellationReasonsDefault;
    },
    imagingCancellationReasonsSchema: function() {
        return imagingCancellationReasonsSchema;
    }
});
const _yup = /*#__PURE__*/ _interop_require_wildcard(require("yup"));
function _getRequireWildcardCache(nodeInterop) {
    if (typeof WeakMap !== "function") return null;
    var cacheBabelInterop = new WeakMap();
    var cacheNodeInterop = new WeakMap();
    return (_getRequireWildcardCache = function(nodeInterop) {
        return nodeInterop ? cacheNodeInterop : cacheBabelInterop;
    })(nodeInterop);
}
function _interop_require_wildcard(obj, nodeInterop) {
    if (!nodeInterop && obj && obj.__esModule) {
        return obj;
    }
    if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return {
            default: obj
        };
    }
    var cache = _getRequireWildcardCache(nodeInterop);
    if (cache && cache.has(obj)) {
        return cache.get(obj);
    }
    var newObj = {
        __proto__: null
    };
    var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;
    for(var key in obj){
        if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;
            if (desc && (desc.get || desc.set)) {
                Object.defineProperty(newObj, key, desc);
            } else {
                newObj[key] = obj[key];
            }
        }
    }
    newObj.default = obj;
    if (cache) {
        cache.set(obj, newObj);
    }
    return newObj;
}
const imagingCancellationReasonSchema = _yup.object({
    value: _yup.string().required().max(31),
    label: _yup.string().required(),
    hidden: _yup.boolean()
});
const imagingCancellationReasonsSchema = _yup.array(imagingCancellationReasonSchema).test({
    name: 'imagingCancellationReasons-dupe',
    message: 'labsCancellationReasons must include an option with value = duplicate',
    test: (reasons)=>{
        if (reasons === undefined) return true; // Don’t fail validation if falling back to default value
        return reasons.some((r)=>r.value === 'duplicate');
    }
}).test({
    name: 'imagingCancellationReasons-err',
    message: 'labsCancellationReasons must include an option with value = entered-in-error',
    test: (reasons)=>{
        if (reasons === undefined) return true; // Don’t fail validation if falling back to default value
        return reasons.some((r)=>r.value === 'entered-in-error');
    }
});
const imagingCancellationReasonsDefault = [
    {
        value: 'clinical',
        label: 'Clinical reason',
        hidden: false
    },
    {
        value: 'duplicate',
        label: 'Duplicate',
        hidden: false
    },
    {
        value: 'entered-in-error',
        label: 'Entered in error',
        hidden: false
    },
    {
        value: 'patient-discharged',
        label: 'Patient discharged',
        hidden: false
    },
    {
        value: 'patient-refused',
        label: 'Patient refused',
        hidden: false
    },
    {
        value: 'cancelled-externally',
        label: 'Cancelled externally via API',
        hidden: true
    },
    {
        value: 'other',
        label: 'Other',
        hidden: false
    }
];

//# sourceMappingURL=imagingCancellationReasons.js.map