"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "AppointmentScheduleLastGeneratedDate", {
    enumerable: true,
    get: function() {
        return AppointmentScheduleLastGeneratedDate;
    }
});
const _dataMigrations = require("@tamanu/database/dataMigrations");
function _define_property(obj, key, value) {
    if (key in obj) {
        Object.defineProperty(obj, key, {
            value: value,
            enumerable: true,
            configurable: true,
            writable: true
        });
    } else {
        obj[key] = value;
    }
    return obj;
}
let AppointmentScheduleLastGeneratedDate = class AppointmentScheduleLastGeneratedDate extends _dataMigrations.CursorDataMigration {
    async getQuery() {
        return `
      WITH updated AS (
        UPDATE appointment_schedules
        SET generated_until_date = latest_appointment.start_time :: date_string
        FROM
          (
            SELECT
              appointments.schedule_id, MAX(appointments.start_time) AS start_time
            FROM appointments
            WHERE schedule_id IS NOT NULL
            GROUP BY schedule_id
          ) AS latest_appointment
        WHERE appointment_schedules.id = latest_appointment.schedule_id
          AND appointment_schedules.id IN (
            SELECT id
            FROM appointment_schedules
            ORDER BY id
            LIMIT $limit
          ) RETURNING id
      )
      SELECT MAX(id :: text) AS "maxId", COUNT(id) AS "count"
      FROM updated;
    `;
    }
    constructor(...args){
        super(...args), _define_property(this, "lastMaxId", '');
    }
};
_define_property(AppointmentScheduleLastGeneratedDate, "defaultBatchSize", Number.MAX_SAFE_INTEGER);
_define_property(AppointmentScheduleLastGeneratedDate, "defaultDelayMs", 50);

//# sourceMappingURL=AppointmentScheduleLastGeneratedDate.js.map