"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "default", {
    enumerable: true,
    get: function() {
        return _default;
    }
});
const Sequelize = require('sequelize');
const _default = {
    up: async (query)=>{
        await query.bulkDelete('sync_metadata', {}); // delete all sync metadata - means a full resync
        await query.changeColumn('sync_metadata', 'channel', {
            type: Sequelize.STRING,
            allowNull: false,
            unique: true
        });
    },
    down: async (query)=>{
        await query.changeColumn('sync_metadata', 'channel', {
            type: Sequelize.STRING,
            allowNull: false
        });
    }
};

//# sourceMappingURL=007_uniqueSyncMetadataChannel.js.map