"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "PharmacyOrderPrescription", {
    enumerable: true,
    get: function() {
        return PharmacyOrderPrescription;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _Model = require("./Model");
const _sync = require("../sync");
let PharmacyOrderPrescription = class PharmacyOrderPrescription extends _Model.Model {
    static initModel({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            quantity: {
                type: _sequelize.DataTypes.INTEGER,
                allowNull: false
            },
            repeats: {
                type: _sequelize.DataTypes.INTEGER,
                allowNull: true
            }
        }, {
            ...options,
            syncDirection: _constants.SYNC_DIRECTIONS.BIDIRECTIONAL
        });
    }
    static initRelations(models) {
        this.belongsTo(models.PharmacyOrder, {
            foreignKey: 'pharmacyOrderId',
            as: 'pharmacyOrder'
        });
        this.belongsTo(models.Prescription, {
            foreignKey: 'prescriptionId',
            as: 'prescription'
        });
    }
    static getListReferenceAssociations() {
        return [
            'pharmacyOrder',
            'prescription'
        ];
    }
    static buildPatientSyncFilter(patientCount, markedForSyncPatientsTable) {
        if (patientCount === 0) {
            return null;
        }
        return (0, _sync.buildEncounterLinkedSyncFilter)([
            this.tableName,
            'pharmacy_orders',
            'encounters'
        ], markedForSyncPatientsTable);
    }
    static async buildSyncLookupQueryDetails() {
        return {
            select: await (0, _sync.buildEncounterPatientIdSelect)(this),
            joins: (0, _sync.buildEncounterLinkedSyncFilterJoins)([
                this.tableName,
                'pharmacy_orders',
                'encounters'
            ])
        };
    }
};

//# sourceMappingURL=PharmacyOrderPrescription.js.map