"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    noteListHandler: function() {
        return noteListHandler;
    },
    notesWithSingleItemListHandler: function() {
        return notesWithSingleItemListHandler;
    }
});
const _sequelize = /*#__PURE__*/ _interop_require_wildcard(require("sequelize"));
const _expressasynchandler = /*#__PURE__*/ _interop_require_default(require("express-async-handler"));
const _constants = require("@tamanu/constants");
const _checkNotePermission = require("../../utils/checkNotePermission");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
function _getRequireWildcardCache(nodeInterop) {
    if (typeof WeakMap !== "function") return null;
    var cacheBabelInterop = new WeakMap();
    var cacheNodeInterop = new WeakMap();
    return (_getRequireWildcardCache = function(nodeInterop) {
        return nodeInterop ? cacheNodeInterop : cacheBabelInterop;
    })(nodeInterop);
}
function _interop_require_wildcard(obj, nodeInterop) {
    if (!nodeInterop && obj && obj.__esModule) {
        return obj;
    }
    if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return {
            default: obj
        };
    }
    var cache = _getRequireWildcardCache(nodeInterop);
    if (cache && cache.has(obj)) {
        return cache.get(obj);
    }
    var newObj = {
        __proto__: null
    };
    var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;
    for(var key in obj){
        if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;
            if (desc && (desc.get || desc.set)) {
                Object.defineProperty(newObj, key, desc);
            } else {
                newObj[key] = obj[key];
            }
        }
    }
    newObj.default = obj;
    if (cache) {
        cache.set(obj, newObj);
    }
    return newObj;
}
const noteListHandler = (recordType)=>(0, _expressasynchandler.default)(async (req, res)=>{
        const { models, params, query } = req;
        const { order = 'ASC', orderBy, noteType, rowsPerPage, page } = query;
        const recordId = params.id;
        await (0, _checkNotePermission.checkNotePermission)(req, {
            recordType,
            recordId
        }, 'list');
        const include = [
            {
                model: models.User,
                as: 'author'
            },
            {
                model: models.User,
                as: 'onBehalfOf'
            },
            {
                model: models.Note,
                as: 'revisedBy',
                required: false,
                attributes: [
                    'date'
                ],
                include: [
                    {
                        model: models.User,
                        as: 'author'
                    },
                    {
                        model: models.User,
                        as: 'onBehalfOf'
                    }
                ]
            }
        ];
        const idRows = await models.Note.sequelize.query(`
      WITH

      -- first create a sub-table with only the notes for this record.
      -- this will make the DISTINCT stuff way faster
      this_record_notes AS (
        SELECT 
          *,
          CASE WHEN revised_by_id IS NULL THEN id ELSE revised_by_id END edit_chain
        FROM notes n
        WHERE record_type = :recordType
          AND record_id = :recordId
          AND deleted_at IS NULL 
      )

      -- now filter out anything except the latest revision for each note
      SELECT DISTINCT ON (edit_chain)
        id
      FROM this_record_notes n
      ORDER BY edit_chain, date DESC
    `, {
            type: _sequelize.QueryTypes.SELECT,
            replacements: {
                recordType,
                recordId
            }
        });
        // any other filtering should happen after the edits have been determined
        // (if we do it all in the same step, we risk including earlier versions of
        // a record that was excluded later, which we absolutely do not want)
        const where = {
            id: {
                [_sequelize.Op.in]: idRows.map((x)=>x.id)
            },
            visibilityStatus: _constants.VISIBILITY_STATUSES.CURRENT,
            ...noteType ? {
                noteType
            } : {}
        };
        const queryOrder = orderBy ? [
            [
                orderBy,
                order.toUpperCase()
            ]
        ] : [
            [
                // Pin TREATMENT_PLAN on top
                _sequelize.default.literal(`case when "Note"."note_type" = '${_constants.NOTE_TYPES.TREATMENT_PLAN}' then 0 else 1 end`)
            ],
            [
                // If the note has already been revised then order by the root note's date.
                // If this is the root note then order by the date of this note
                _sequelize.default.literal('case when "revisedBy"."date" notnull then "revisedBy"."date" else "Note"."date" end desc')
            ]
        ];
        const rows = await models.Note.findAll({
            include,
            where,
            order: queryOrder,
            limit: rowsPerPage,
            offset: page && rowsPerPage ? page * rowsPerPage : undefined
        });
        const totalCount = await models.Note.count({
            where
        });
        res.send({
            data: rows,
            count: totalCount
        });
    });
const notesWithSingleItemListHandler = (recordType)=>(0, _expressasynchandler.default)(async (req, res)=>{
        const { models, params } = req;
        const recordId = params.id;
        await (0, _checkNotePermission.checkNotePermission)(req, {
            recordType,
            recordId
        }, 'list');
        const notes = await models.Note.findAll({
            include: [
                {
                    model: models.User,
                    as: 'author'
                },
                {
                    model: models.User,
                    as: 'onBehalfOf'
                }
            ],
            where: {
                recordId,
                recordType,
                visibilityStatus: _constants.VISIBILITY_STATUSES.CURRENT
            },
            order: [
                [
                    'date',
                    'DESC'
                ]
            ]
        });
        res.send({
            data: notes,
            count: notes.length
        });
    });

//# sourceMappingURL=noteListHandler.js.map