/* eslint-disable no-unused-vars */ function _define_property(obj, key, value) {
    if (key in obj) {
        Object.defineProperty(obj, key, {
            value: value,
            enumerable: true,
            configurable: true,
            writable: true
        });
    } else {
        obj[key] = value;
    }
    return obj;
}
import { get as lodashGet, pick } from 'lodash';
import { buildSettings } from '..';
import { settingsCache } from '../cache';
export const KEYS_EXPOSED_TO_FRONT_END = [
    'audit',
    'appointments',
    'ageDisplayFormat',
    'customisations',
    'features',
    'fields',
    'imagingCancellationReasons',
    'imagingPriorities',
    'insurer',
    'customisations',
    'printMeasures',
    'invoice',
    'labsCancellationReasons',
    'templates',
    'layouts',
    'triageCategories',
    'upcomingVaccinations',
    'vaccinations',
    'vitalEditReasons',
    'medications'
];
export class ReadSettings {
    async get(key) {
        const settings = await this.getAll();
        return lodashGet(settings, key);
    }
    // This is what is called on login. This gets only settings relevant to
    // the frontend so only what is needed is sent. No sensitive data is sent.
    async getFrontEndSettings() {
        let settings = settingsCache.getFrontEndSettings();
        if (!settings) {
            const allSettings = await this.getAll();
            settings = pick(allSettings, KEYS_EXPOSED_TO_FRONT_END);
            settingsCache.setFrontEndSettings(settings);
        }
        return settings;
    }
    async getAll() {
        let settings = settingsCache.getAllSettings();
        if (!settings) {
            settings = await buildSettings(this.models, this.facilityId);
            settingsCache.setAllSettings(settings);
        }
        return settings;
    }
    constructor(models, facilityId){
        _define_property(this, "models", void 0);
        _define_property(this, "facilityId", void 0);
        this.models = models;
        this.facilityId = facilityId;
    }
}

//# sourceMappingURL=ReadSettings.js.map