"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    removeDuplicatedDischarges: function() {
        return removeDuplicatedDischarges;
    },
    removeDuplicatedDischargesCommand: function() {
        return removeDuplicatedDischargesCommand;
    }
});
const _commander = require("commander");
const _migrateDataInBatches = require("./migrateDataInBatches/migrateDataInBatches");
async function removeDuplicatedDischarges({ batchSize = Number.MAX_SAFE_INTEGER, sleepAsyncDuration = 50 } = {}) {
    return (0, _migrateDataInBatches.migrateDataInBatches)('RemoveDuplicatedDischarges', {
        batchSize,
        delayMs: sleepAsyncDuration
    });
}
const removeDuplicatedDischargesCommand = new _commander.Command('removeDuplicatedDischarges').description("[Deprecated] Remove duplicated discharges (use migrateDataInBatches instead, it's identical but has standardised options)").option('-b, --batchSize <number>', 'Batching size for number of encounters').option('-s, --sleepAsyncDuration <number>', 'Sleep duration between batches in milliseconds (default 50ms)').action(removeDuplicatedDischarges);

//# sourceMappingURL=removeDuplicatedDischarges.js.map