"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "InvoiceProduct", {
    enumerable: true,
    get: function() {
        return InvoiceProduct;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _Model = require("./Model");
let InvoiceProduct = class InvoiceProduct extends _Model.Model {
    static initModel({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            name: {
                type: _sequelize.DataTypes.TEXT,
                allowNull: false
            },
            price: {
                type: _sequelize.DataTypes.DECIMAL,
                allowNull: true
            },
            discountable: {
                type: _sequelize.DataTypes.BOOLEAN,
                allowNull: false
            },
            visibilityStatus: {
                type: _sequelize.DataTypes.STRING,
                allowNull: false,
                defaultValue: _constants.VISIBILITY_STATUSES.CURRENT
            }
        }, {
            ...options,
            syncDirection: _constants.SYNC_DIRECTIONS.BIDIRECTIONAL
        });
    }
    static initRelations(models) {
        this.belongsTo(models.ReferenceData, {
            foreignKey: 'id',
            as: 'referenceData',
            constraints: false
        });
        this.belongsTo(models.LabTestType, {
            foreignKey: 'id',
            as: 'labTestType',
            constraints: false
        });
    }
    static buildSyncFilter() {
        return null; // syncs everywhere
    }
    static async buildSyncLookupQueryDetails() {
        return null; // syncs everywhere
    }
    static getFullReferenceAssociations() {
        return [
            'referenceData',
            'labTestType'
        ];
    }
    addVirtualFields() {
        this.dataValues.type = this.referenceData?.type ?? (this.labTestType?.code ? _constants.OTHER_REFERENCE_TYPES.LAB_TEST_TYPE : _constants.IMAGING_TYPES_VALUES.includes(this.id) ? _constants.REFERENCE_TYPES.IMAGING_TYPE : undefined);
        this.dataValues.code = this.referenceData?.code ?? this.labTestType?.code ?? (_constants.IMAGING_TYPES_VALUES.includes(this.id) ? this.id : undefined);
        return this;
    }
};

//# sourceMappingURL=InvoiceProduct.js.map