"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "PatientVRSData", {
    enumerable: true,
    get: function() {
        return PatientVRSData;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _Model = require("./Model");
let PatientVRSData = class PatientVRSData extends _Model.Model {
    static initModel({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            idType: _sequelize.DataTypes.STRING,
            identifier: _sequelize.DataTypes.STRING,
            // if we don't have a matching village, persist the unmatched name here
            unmatchedVillageName: _sequelize.DataTypes.STRING,
            isDeletedByRemote: {
                type: _sequelize.DataTypes.BOOLEAN,
                defaultValue: false,
                allowNull: false
            }
        }, {
            ...options,
            tableName: 'patient_vrs_data',
            syncDirection: _constants.SYNC_DIRECTIONS.DO_NOT_SYNC
        });
    }
    static initRelations(models) {
        this.belongsTo(models.Patient, {
            foreignKey: 'patientId',
            as: 'patient'
        });
    }
};

//# sourceMappingURL=PatientVRSData.js.map