"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    AuthError: function() {
        return AuthError;
    },
    AuthExpiredError: function() {
        return AuthExpiredError;
    },
    AuthInvalidError: function() {
        return AuthInvalidError;
    },
    ForbiddenError: function() {
        return ForbiddenError;
    },
    NotFoundError: function() {
        return NotFoundError;
    },
    ResourceConflictError: function() {
        return ResourceConflictError;
    },
    ServerResponseError: function() {
        return ServerResponseError;
    },
    ServerUnavailableError: function() {
        return ServerUnavailableError;
    },
    VersionIncompatibleError: function() {
        return VersionIncompatibleError;
    },
    getVersionIncompatibleMessage: function() {
        return getVersionIncompatibleMessage;
    },
    isRecoverable: function() {
        return isRecoverable;
    }
});
const _constants = require("@tamanu/constants");
let ServerUnavailableError = class ServerUnavailableError extends Error {
};
let ServerResponseError = class ServerResponseError extends Error {
    constructor(message, response){
        super(message);
        this.response = response;
    }
};
let NotFoundError = class NotFoundError extends ServerResponseError {
};
let AuthError = class AuthError extends ServerResponseError {
};
let AuthInvalidError = class AuthInvalidError extends AuthError {
};
let AuthExpiredError = class AuthExpiredError extends AuthError {
};
let ForbiddenError = class ForbiddenError extends AuthError {
};
let VersionIncompatibleError = class VersionIncompatibleError extends ServerResponseError {
};
let ResourceConflictError = class ResourceConflictError extends ServerResponseError {
};
function isRecoverable(error) {
    if (error instanceof ServerUnavailableError) {
        return true;
    }
    if (!(error instanceof ServerResponseError)) {
        return false;
    }
    if (error instanceof AuthInvalidError || error instanceof VersionIncompatibleError) {
        return false;
    }
    if (error.response.status >= 400 && error.response.status < 500) {
        return false;
    }
    if (error.message.includes('Insufficient') && error.message.toLowerCase().includes('storage')) {
        return false;
    }
    if (error.message.includes('Sync session')) {
        return false;
    }
    return true;
}
function getVersionIncompatibleMessage(error, response) {
    if (error.message === _constants.VERSION_COMPATIBILITY_ERRORS.LOW) {
        return 'Tamanu is out of date, reload to get the new version! If that does not work, contact your system administrator.';
    }
    if (error.message === _constants.VERSION_COMPATIBILITY_ERRORS.HIGH) {
        const maxAppVersion = response.headers.get('X-Max-Client-Version').split('.', 3).slice(0, 2).join('.');
        return `The Tamanu Facility Server only supports up to v${maxAppVersion}, and needs to be upgraded. Please contact your system administrator.`;
    }
    return null;
}

//# sourceMappingURL=errors.js.map