"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "createModelExporter", {
    enumerable: true,
    get: function() {
        return createModelExporter;
    }
});
const _constants = require("@tamanu/constants");
const _AdministeredVaccineExporter = require("./AdministeredVaccineExporter");
const _DefaultDataExporter = require("./DefaultDataExporter");
const _PatientExporter = require("./PatientExporter");
const _LabTestPanelExporter = require("./LabTestPanelExporter");
const _PermissionExporter = require("./PermissionExporter");
const _PatientFieldDefinitionExporter = require("./PatientFieldDefinitionExporter");
const _ReferenceDataExporter = require("./ReferenceDataExporter");
const _TranslatedStringExporter = require("./TranslatedStringExporter");
const _TaskSetExporter = require("./TaskSetExporter");
const _UserExporter = require("./UserExporter");
const _TaskTemplateExporter = require("./TaskTemplateExporter");
const _DrugExporter = require("./DrugExporter");
const _MedicationTemplateExporter = require("./MedicationTemplateExporter");
const _MedicationSetExporter = require("./MedicationSetExporter");
const CustomExportersByDataType = {
    permission: _PermissionExporter.PermissionExporter,
    patient: _PatientExporter.PatientExporter,
    administeredVaccine: _AdministeredVaccineExporter.AdministeredVaccineExporter,
    labTestPanel: _LabTestPanelExporter.LabTestPanelExporter,
    patientFieldDefinition: _PatientFieldDefinitionExporter.PatientFieldDefinitionExporter,
    translatedString: _TranslatedStringExporter.TranslatedStringExporter,
    user: _UserExporter.UserExporter,
    [_constants.REFERENCE_TYPES.TASK_TEMPLATE]: _TaskTemplateExporter.TaskTemplateExporter,
    [_constants.REFERENCE_TYPES.TASK_SET]: _TaskSetExporter.TaskSetExporter,
    [_constants.REFERENCE_TYPES.DRUG]: _DrugExporter.DrugExporter,
    [_constants.REFERENCE_TYPES.MEDICATION_TEMPLATE]: _MedicationTemplateExporter.MedicationTemplateExporter,
    [_constants.REFERENCE_TYPES.MEDICATION_SET]: _MedicationSetExporter.MedicationSetExporter
};
const createModelExporter = (context, dataType)=>{
    const referenceDataTypes = [
        ..._constants.REFERENCE_TYPE_VALUES,
        'diagnosis'
    ];
    const CustomExporterClass = CustomExportersByDataType[dataType];
    if (CustomExporterClass) {
        return new CustomExporterClass(context, dataType);
    }
    if (referenceDataTypes.includes(dataType)) {
        return new _ReferenceDataExporter.ReferenceDataExporter(context, dataType);
    }
    return new _DefaultDataExporter.DefaultDataExporter(context, dataType);
};

//# sourceMappingURL=createModelExporter.js.map