"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    checkIntegrationsConfig: function() {
        return checkIntegrationsConfig;
    },
    initIntegrations: function() {
        return initIntegrations;
    },
    integrationRoutes: function() {
        return integrationRoutes;
    },
    publicIntegrationRoutes: function() {
        return publicIntegrationRoutes;
    }
});
const _express = /*#__PURE__*/ _interop_require_default(require("express"));
const _config = /*#__PURE__*/ _interop_require_default(require("config"));
const _logging = require("@tamanu/shared/services/logging");
const _fijivrs = /*#__PURE__*/ _interop_require_wildcard(require("./fiji-vrs"));
const _fijivps = /*#__PURE__*/ _interop_require_wildcard(require("./fiji-vps"));
const _Signer = /*#__PURE__*/ _interop_require_wildcard(require("./Signer"));
const _fijiAspenMediciReport = /*#__PURE__*/ _interop_require_wildcard(require("./fijiAspenMediciReport"));
const _mSupply = /*#__PURE__*/ _interop_require_wildcard(require("./mSupply"));
const _fhir = /*#__PURE__*/ _interop_require_wildcard(require("./fhir"));
const _omniLab = /*#__PURE__*/ _interop_require_wildcard(require("./omniLab"));
const _EuDcc = require("./EuDcc");
const _VdsNc = require("./VdsNc");
const _config1 = require("./fhir/config");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
function _getRequireWildcardCache(nodeInterop) {
    if (typeof WeakMap !== "function") return null;
    var cacheBabelInterop = new WeakMap();
    var cacheNodeInterop = new WeakMap();
    return (_getRequireWildcardCache = function(nodeInterop) {
        return nodeInterop ? cacheNodeInterop : cacheBabelInterop;
    })(nodeInterop);
}
function _interop_require_wildcard(obj, nodeInterop) {
    if (!nodeInterop && obj && obj.__esModule) {
        return obj;
    }
    if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return {
            default: obj
        };
    }
    var cache = _getRequireWildcardCache(nodeInterop);
    if (cache && cache.has(obj)) {
        return cache.get(obj);
    }
    var newObj = {
        __proto__: null
    };
    var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;
    for(var key in obj){
        if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;
            if (desc && (desc.get || desc.set)) {
                Object.defineProperty(newObj, key, desc);
            } else {
                newObj[key] = obj[key];
            }
        }
    }
    newObj.default = obj;
    if (cache) {
        cache.set(obj, newObj);
    }
    return newObj;
}
const integrations = {
    fijiVrs: _fijivrs,
    fijiVps: _fijivps,
    signer: _Signer,
    fijiAspenMediciReport: _fijiAspenMediciReport,
    mSupply: _mSupply,
    fhir: _fhir,
    omniLab: _omniLab
};
const integrationRoutes = _express.default.Router();
const publicIntegrationRoutes = _express.default.Router();
const initIntegrations = async (ctx)=>{
    for (const [key, integration] of Object.entries(integrations)){
        if (_config.default.integrations[key].enabled) {
            _logging.log.info(`initIntegrations: ${key}: initialising`);
            const { routes, publicRoutes, initAppContext } = integration;
            if (initAppContext) {
                await initAppContext(ctx);
            }
            if (routes) {
                const isRouter = Object.getPrototypeOf(routes) === _express.default.Router;
                const actualRoutes = isRouter ? routes : routes(ctx);
                integrationRoutes.use(`/${key}`, actualRoutes);
            }
            if (publicRoutes) {
                publicIntegrationRoutes.use(`/${key}`, publicRoutes);
            }
        } else {
            _logging.log.info(`initIntegrations: ${key}: disabled, did not initialise`);
        }
    }
};
function checkIntegrationsConfig() {
    (0, _EuDcc.checkEuDccConfig)();
    (0, _Signer.checkSignerConfig)();
    (0, _VdsNc.checkVdsNcConfig)();
    (0, _config1.checkFhirConfig)();
    if ((_config.default.integrations.euDcc.enabled || _config.default.integrations.vdsNc.enabled) && !_config.default.integrations.signer.enabled) {
        throw new Error('euDcc and vdsNc integrations require the signer integration to be enabled');
    }
    if (_config.default.integrations.euDcc.enabled && _config.default.integrations.vdsNc.enabled) {
        throw new Error('Cannot enable both euDcc and vdsNc integrations at the same time');
    }
}

//# sourceMappingURL=index.js.map