<!-- Note: This file is automatically generated from source code comments. Changes made in this file will be overridden. -->

# Function conj

Compute the complex conjugate of a complex value.
If `x = a+bi`, the complex conjugate of `x` is `a - bi`.

For matrices, the function is evaluated element wise.


## Syntax

```js
math.conj(x)
```

### Parameters

Parameter | Type | Description
--------- | ---- | -----------
`x` | number &#124; BigNumber &#124; Complex &#124; Array &#124; Matrix |  A complex number or array with complex numbers

### Returns

Type | Description
---- | -----------
number &#124; BigNumber &#124; Complex &#124; Array &#124; Matrix |  The complex conjugate of x


## Examples

```js
math.conj(math.complex('2 + 3i'))  // returns Complex 2 - 3i
math.conj(math.complex('2 - 3i'))  // returns Complex 2 + 3i
math.conj(math.complex('-5.2i'))  // returns Complex 5.2i
```


## See also

[re](re.md),
[im](im.md),
[arg](arg.md),
[abs](abs.md)
