"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = require("sequelize");
async function up(query) {
    await query.sequelize.query(`ALTER TABLE settings ALTER COLUMN id TYPE uuid USING id::uuid`);
    await query.changeColumn('settings', 'id', {
        type: _sequelize.DataTypes.UUID,
        allowNull: false,
        primaryKey: true,
        defaultValue: _sequelize.Sequelize.fn('uuid_generate_v4')
    });
    await query.changeColumn('settings', 'created_at', {
        type: _sequelize.DataTypes.DATE,
        defaultValue: _sequelize.Sequelize.fn('current_timestamp', 3),
        allowNull: false
    });
    await query.changeColumn('settings', 'updated_at', {
        type: _sequelize.DataTypes.DATE,
        defaultValue: _sequelize.Sequelize.fn('current_timestamp', 3),
        allowNull: false
    });
}
async function down(query) {
    await query.changeColumn('settings', 'id', {
        type: 'varchar(255)',
        allowNull: false,
        primaryKey: true
    });
    await query.changeColumn('settings', 'created_at', {
        type: _sequelize.DataTypes.DATE
    });
    await query.changeColumn('settings', 'updated_at', {
        type: _sequelize.DataTypes.DATE
    });
}

//# sourceMappingURL=1673818589231-settingsDefaultValues.js.map