"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
async function up(query) {
    await query.sequelize.query(`
    DROP INDEX IF EXISTS notes_record_id_idx;
  `);
    await query.sequelize.query(`
    CREATE INDEX IF NOT EXISTS notes_record_id_idx ON notes USING HASH (record_id);
  `);
}
async function down(query) {
    await query.sequelize.query(`
    DROP INDEX IF EXISTS notes_record_id_idx;
  `);
    await query.sequelize.query(`
    CREATE INDEX IF NOT EXISTS notes_record_id_idx ON notes (record_id); -- btree is default
  `);
}

//# sourceMappingURL=1702610467280-updateRecordIdIndexFromBTreeToHashInNotes.js.map