"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "TaskTemplateDesignation", {
    enumerable: true,
    get: function() {
        return TaskTemplateDesignation;
    }
});
const _constants = require("@tamanu/constants");
const _Model = require("./Model");
let TaskTemplateDesignation = class TaskTemplateDesignation extends _Model.Model {
    static initModel({ primaryKey, ...options }) {
        super.init({
            id: primaryKey
        }, {
            ...options,
            syncDirection: _constants.SYNC_DIRECTIONS.BIDIRECTIONAL
        });
    }
    static initRelations(models) {
        this.belongsTo(models.TaskTemplate, {
            foreignKey: 'taskTemplateId',
            as: 'taskTemplate'
        });
        this.belongsTo(models.ReferenceData, {
            foreignKey: 'designationId',
            as: 'designation'
        });
    }
    static buildSyncFilter() {
        return null; // syncs everywhere
    }
    static async buildSyncLookupQueryDetails() {
        return null; // syncs everywhere
    }
};

//# sourceMappingURL=TaskTemplateDesignation.js.map