import { DataTypes } from 'sequelize';
import { SYNC_DIRECTIONS } from '@tamanu/constants';
import { Model } from './Model';
export class IPSRequest extends Model {
    static initModel({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            createdBy: DataTypes.STRING,
            email: DataTypes.STRING,
            status: DataTypes.STRING,
            error: DataTypes.TEXT
        }, {
            ...options,
            tableName: 'ips_requests',
            syncDirection: SYNC_DIRECTIONS.PUSH_TO_CENTRAL
        });
    }
    static initRelations(models) {
        this.belongsTo(models.Patient, {
            foreignKey: 'patientId',
            as: 'patient'
        });
        this.belongsTo(models.User, {
            foreignKey: 'createdBy',
            as: 'createdByUser'
        });
    }
}

//# sourceMappingURL=IPSRequest.js.map