"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "log", {
    enumerable: true,
    get: function() {
        return log;
    }
});
const _winston = /*#__PURE__*/ _interop_require_default(require("winston"));
const _config = /*#__PURE__*/ _interop_require_default(require("config"));
const _console = require("./console");
const _honeycomb = require("./honeycomb");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
// defensive destructure to allow for testing shared directly
const { path } = _config.default?.log || {};
const log = _winston.default.createLogger({
    level: 'info',
    format: _winston.default.format.json(),
    transports: [
        path ? new _winston.default.transports.File({
            filename: `${path}/error.log`,
            level: 'error'
        }) : null,
        path ? new _winston.default.transports.File({
            filename: `${path}/combined.log`
        }) : null,
        _console.localTransport,
        _honeycomb.honeycombTransport
    ].filter((t)=>!!t)
});

//# sourceMappingURL=log.js.map