"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    getTracer: function() {
        return getTracer;
    },
    spanWrapFn: function() {
        return spanWrapFn;
    },
    tracingSDK: function() {
        return tracingSDK;
    }
});
const _opentelemetrynode = require("@honeycombio/opentelemetry-node");
const _api = require("@opentelemetry/api");
const _resources = require("@opentelemetry/resources");
const _autoinstrumentationsnode = require("@opentelemetry/auto-instrumentations-node");
const _config = /*#__PURE__*/ _interop_require_default(require("config"));
const _context = require("./context");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
function setupTracing() {
    const { apiKey, sampleRate = 1, enabled } = _config.default?.honeycomb || {};
    if (!enabled || !apiKey) return null;
    const context = (0, _context.serviceContext)();
    if (!context) return null;
    const sdk = new _opentelemetrynode.HoneycombSDK({
        apiKey,
        serviceName: (0, _context.serviceName)(context),
        sampleRate,
        instrumentations: [
            (0, _autoinstrumentationsnode.getNodeAutoInstrumentations)({
                '@opentelemetry/instrumentation-pg': {
                    enhancedDatabaseReporting: _context.ENV !== 'production',
                    requestHook: (span, { query })=>{
                        if (_context.ENV === 'production' && (span.name.startsWith('pg.query:UPDATE') || span.name.startsWith('pg.query:INSERT') || query.text.startsWith('INSERT') || query.text.startsWith('UPDATE'))) {
                            span.setAttribute('db.statement', 'REDACTED UPDATE/INSERT');
                        }
                    }
                }
            })
        ],
        resource: new _resources.Resource(context)
    });
    sdk.start();
    return sdk;
}
const tracingSDK = setupTracing();
const getTracer = (name = 'tamanu')=>_api.trace.getTracer(name);
const spanWrapFn = async (name, fn, attributes = {}, tracer = 'tamanu')=>getTracer(tracer).startActiveSpan(name, async (span)=>{
        span.setAttribute('code.function', name);
        span.setAttributes(attributes);
        try {
            return await fn(span);
        } catch (e) {
            span.recordException(e);
            throw e;
        } finally{
            span.end();
        }
    });

//# sourceMappingURL=tracing.js.map