/**
 * Something compact, identifiable as ours, and easy to decode into useful data.
 *
 * @param {string} vaccinationId
 * @param {string} countryCode
 * @returns {string}
 */ "use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "generateDefaultFormatUVCI", {
    enumerable: true,
    get: function() {
        return generateDefaultFormatUVCI;
    }
});
function generateDefaultFormatUVCI(vaccinationId, countryCode) {
    const id = Buffer.from(vaccinationId.replace(/-/g, ''), 'hex').toString('base64').replace(/=/g, '');
    return `TAMANU1/${countryCode}/${id}`;
}

//# sourceMappingURL=tamanu.js.map