import React from 'react';
import { StyleSheet, View } from '@react-pdf/renderer';
import { Col, Signature } from './Layout';
import { P } from './Typography';
const signingSectionStyles = StyleSheet.create({
    underlinedText: {
        textDecoration: 'underline'
    },
    signatureView: {
        paddingRight: 32
    }
});
export const BaseSigningSection = ({ title })=>/*#__PURE__*/ React.createElement(Col, null, title && /*#__PURE__*/ React.createElement(P, {
        bold: true,
        style: signingSectionStyles.underlinedText
    }, title), /*#__PURE__*/ React.createElement(View, {
        style: signingSectionStyles.signatureView
    }, /*#__PURE__*/ React.createElement(Signature, {
        text: 'Signed',
        fontSize: 9,
        lineThickness: 0.5
    }), /*#__PURE__*/ React.createElement(Signature, {
        text: 'Date',
        fontSize: 9,
        lineThickness: 0.5
    })));

//# sourceMappingURL=BaseSigningSection.js.map