"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.configureHoneycombHttpProtoMetricExporter = void 0;
const exporter_metrics_otlp_proto_1 = require("@opentelemetry/exporter-metrics-otlp-proto");
const exporter_utils_1 = require("./exporter-utils");
const honeycomb_options_1 = require("./honeycomb-options");
/**
 * Builds and returns an OTLP Metric exporter that sends data over http/protobuf
 * @param options The {@link HoneycombOptions} used to configure the exporter
 * @returns an {@link OTLPMetricExporter} configured to send telemetry to Honeycomb over http/protobuf
 */
function configureHoneycombHttpProtoMetricExporter(options) {
    const opts = (0, honeycomb_options_1.computeOptions)(options);
    return new exporter_metrics_otlp_proto_1.OTLPMetricExporter({
        url: opts === null || opts === void 0 ? void 0 : opts.metricsEndpoint,
        headers: {
            [exporter_utils_1.OTLP_HEADER_KEY]: exporter_utils_1.OTLP_PROTO_VERSION,
            [exporter_utils_1.TEAM_HEADER_KEY]: opts === null || opts === void 0 ? void 0 : opts.metricsApiKey,
            [exporter_utils_1.DATASET_HEADER_KEY]: opts === null || opts === void 0 ? void 0 : opts.metricsDataset,
        },
    });
}
exports.configureHoneycombHttpProtoMetricExporter = configureHoneycombHttpProtoMetricExporter;
