"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = require("sequelize");
async function up(query) {
    await query.createTable('lab_test_panels', {
        id: {
            type: _sequelize.DataTypes.STRING,
            allowNull: false,
            primaryKey: true,
            defaultValue: _sequelize.Sequelize.fn('uuid_generate_v4')
        },
        created_at: {
            type: _sequelize.DataTypes.DATE,
            defaultValue: _sequelize.Sequelize.fn('current_timestamp', 3),
            allowNull: false
        },
        updated_at: {
            type: _sequelize.DataTypes.DATE,
            defaultValue: _sequelize.Sequelize.fn('current_timestamp', 3),
            allowNull: false
        },
        deleted_at: {
            type: _sequelize.DataTypes.DATE,
            allowNull: true
        },
        name: {
            type: _sequelize.DataTypes.STRING,
            allowNull: false
        },
        code: {
            type: _sequelize.DataTypes.STRING,
            allowNull: false
        },
        visibility_status: {
            type: _sequelize.DataTypes.STRING,
            allowNull: false,
            defaultValue: 'current'
        }
    });
}
async function down(query) {
    await query.dropTable('lab_test_panels');
}

//# sourceMappingURL=1676619492367-AddLabPanelsTable.js.map