"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    NON_DETERMINISTIC: function() {
        return NON_DETERMINISTIC;
    },
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const NON_DETERMINISTIC = true;
async function up(query) {
    await query.sequelize.query(`
    DROP TABLE "fhir"."diagnostic_reports";
  `);
}
async function down(query) {
    await query.sequelize.query(`
      CREATE TABLE fhir.diagnostic_reports (
        id uuid DEFAULT uuid_generate_v4() PRIMARY KEY,
        version_id uuid NOT NULL DEFAULT uuid_generate_v4(),
        upstream_id character varying(255) NOT NULL,
        last_updated timestamp without time zone NOT NULL DEFAULT now(),
        extension jsonb NOT NULL DEFAULT '[]'::jsonb,
        identifier jsonb NOT NULL DEFAULT '[]'::jsonb,
        status text NOT NULL,
        code jsonb NOT NULL,
        subject jsonb,
        effective_date_time text,
        issued text,
        performer jsonb NOT NULL DEFAULT '[]'::jsonb,
        result jsonb NOT NULL DEFAULT '[]'::jsonb
    );
  `);
}

//# sourceMappingURL=1709719785865-dropDiagnosticReport.js.map