"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "patientCarePlan", {
    enumerable: true,
    get: function() {
        return patientCarePlan;
    }
});
const _express = /*#__PURE__*/ _interop_require_default(require("express"));
const _expressasynchandler = /*#__PURE__*/ _interop_require_default(require("express-async-handler"));
const _constants = require("@tamanu/constants");
const _errors = require("@tamanu/shared/errors");
const _crudHelpers = require("@tamanu/shared/utils/crudHelpers");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const patientCarePlan = _express.default.Router();
patientCarePlan.get('/:id', (0, _crudHelpers.simpleGet)('PatientCarePlan'));
patientCarePlan.put('/:id', (0, _crudHelpers.simplePut)('PatientCarePlan'));
patientCarePlan.post('/$', (0, _expressasynchandler.default)(async (req, res)=>{
    const { models: { PatientCarePlan } } = req;
    req.checkPermission('create', 'PatientCarePlan');
    if (!req.body.content) {
        throw new _errors.InvalidParameterError('Content is a required field');
    }
    const newCarePlan = await PatientCarePlan.create(req.body);
    await newCarePlan.createNote({
        noteType: _constants.NOTE_TYPES.TREATMENT_PLAN,
        date: req.body.date,
        content: req.body.content,
        authorId: req.user.id,
        onBehalfOfId: req.body.examinerId
    });
    res.send(newCarePlan);
}));
patientCarePlan.get('/:id/notes', (0, _expressasynchandler.default)(async (req, res)=>{
    const { models, params } = req;
    req.checkPermission('read', 'PatientCarePlan');
    const notes = await models.Note.findAll({
        include: [
            {
                model: models.User,
                as: 'author'
            },
            {
                model: models.User,
                as: 'onBehalfOf'
            }
        ],
        where: {
            recordId: params.id,
            recordType: _constants.NOTE_RECORD_TYPES.PATIENT_CARE_PLAN,
            noteType: _constants.NOTE_TYPES.TREATMENT_PLAN,
            visibilityStatus: _constants.VISIBILITY_STATUSES.CURRENT
        },
        // TODO add test to verify this order
        order: [
            [
                'createdAt',
                'ASC'
            ]
        ]
    });
    res.send(notes);
}));
patientCarePlan.post('/:id/notes', (0, _expressasynchandler.default)(async (req, res)=>{
    req.checkPermission('create', 'PatientCarePlan');
    const { models } = req;
    const newNote = await models.Note.create({
        recordId: req.params.id,
        recordType: _constants.NOTE_RECORD_TYPES.PATIENT_CARE_PLAN,
        date: req.body.date,
        noteType: _constants.NOTE_TYPES.TREATMENT_PLAN,
        content: req.body.content,
        authorId: req.user.id,
        onBehalfOfId: req.body.onBehalfOfId
    });
    res.send(newNote);
}));

//# sourceMappingURL=patientCarePlan.js.map