"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "telegramRoutes", {
    enumerable: true,
    get: function() {
        return telegramRoutes;
    }
});
const _express = /*#__PURE__*/ _interop_require_default(require("express"));
const _expressasynchandler = /*#__PURE__*/ _interop_require_default(require("express-async-handler"));
const _constants = require("@tamanu/constants");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const telegramRoutes = _express.default.Router();
/**
 *
 * @param {ReturnType<import('../../../services/websocketClientService').defineWebsocketClientService>} ws
 */ const getTelegramBotInfo = async (ws)=>{
    return await new Promise((resolve, reject)=>{
        try {
            ws?.emit(_constants.WS_EVENTS.TELEGRAM_GET_BOT_INFO);
            ws?.listenOnce(_constants.WS_EVENTS.TELEGRAM_BOT_INFO, (botInfo)=>resolve(botInfo));
        } catch (e) {
            reject(e);
        }
    });
};
telegramRoutes.get('/bot-info', (0, _expressasynchandler.default)(async (req, res)=>{
    req.flagPermissionChecked();
    const botInfo = await getTelegramBotInfo(req?.websocketClientService);
    res.send(botInfo);
}));

//# sourceMappingURL=telegramRoutes.js.map